%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Function name: apply_par_corr_n2o
%
% Scope:    apply parameter correction to concentrations
%
% Input:    data (structure),
%           bindata (structure),
%           binref (structure),
%           list of gas names (cell),
%           list of gas type "flags" (i.e., MPV positions) (double),
%           parameter corr index (double),
%           anchor dataset name (string),
%           index plot requested (double)
%
% Output:   corrected "bindata" and "binref" structures,
%           overview figures (if requested)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [ref,binref,fitcoeff,bindata] = apply_par_corr_n2o(data,bindata,binref,gasnames,gastypeflag,par_idx,par_corr_conc_anchor,plot_request)

tic;fprintf('Running function apply_par_corr_n2o...\n');

if par_idx==1   %p_Cell correction
    bindata_idx=7; end

if par_idx==2   %T_Cell correction
    bindata_idx=8; end

if par_idx==3   %T_Chiller correction
    bindata_idx=9; end

if par_idx==4   %T_P9 correction
    bindata_idx=10; end

target_idx=2;   %N2O index

% calculate fit coefficients
fitcoeff = calc_fit_coeff(bindata,gasnames,par_corr_conc_anchor);

% get fit coefficients for N2O correction
slope_n2o = fitcoeff.slope(target_idx,bindata_idx);
intercept_n2o = fitcoeff.intercept(target_idx,bindata_idx);

ind_anchor=find(ismember(gasnames,par_corr_conc_anchor));

%% plot data before correction

if plot_request    
    plot_par_corr_n2o(data,bindata,binref,gasnames,bindata_idx,target_idx,slope_n2o,intercept_n2o,ind_anchor,'Before parameter correction');
end

%% apply correction

for i=1:width(gastypeflag)
       bindata.(gasnames{1,i})(:,target_idx)=bindata.(gasnames{1,i})(:,target_idx)-slope_n2o(1,1)*(bindata.(gasnames{1,i})(:,bindata_idx)-binref.(gasnames{1,ind_anchor})(1,bindata_idx));
end

bindata.all(:,target_idx)=bindata.all(:,target_idx)-slope_n2o(1,1)*(bindata.all(:,bindata_idx)-binref.(gasnames{1,ind_anchor})(1,bindata_idx));

%% recalculate ref conditions and fit coefficients

[ref, binref, bindata] = calc_ref_conditions(data,bindata,gasnames,gastypeflag);
fitcoeff = calc_fit_coeff(bindata,gasnames,par_corr_conc_anchor);
    
%% get new slope and intercept after correction

slope_n2o = fitcoeff.slope(target_idx,bindata_idx);
intercept_n2o = fitcoeff.intercept(target_idx,bindata_idx);
    
%% plot data after correction

if plot_request    
    plot_par_corr_n2o(data,bindata,binref,gasnames,bindata_idx,target_idx,slope_n2o,intercept_n2o,ind_anchor,'After parameter correction');
end

%%
time_elapsed=toc; fprintf('apply_par_corr_n2o completed (execution time: %1.2f s)\n',time_elapsed); 

end

